﻿using PpmsDataWebService.Mappers;
using VA.PPMS.Context;
using System.Collections.Generic;
using System.Linq;
using System.Net;
using System.Net.Http;
using System.Threading.Tasks;
using System.Web;
using System.Web.Http;
using Microsoft.AspNet.OData;
using Microsoft.AspNet.OData.Routing;
using Microsoft.Web.Http;

namespace PpmsDataWebService.Controllers
{

    //[Authorize]
    [EnableQuery]
    [ApiVersion("1.0")]
    public class ServiceAvailabilitiesController : ODataController
    {
        [ODataRoute("ServiceAvailabilities({Name})")]
        public async Task<HttpResponseMessage> Get([FromODataUri] string Name)
        {
            //We will use the Query type found in URL to determine if Expanded properties need to be mapped. 
            var queryType = HttpContext.Current.Request.Url.Query;

            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {                
                //Retrieve the Service Availability
                var ppmsServiceAvailability = context.ppms_serviceavailabilitySet.FirstOrDefault(i => i.ppms_name.Contains(Name));
                if (ppmsServiceAvailability != null)
                {
                    var ppmsServericeAvailabilitiesList = new List<ppms_serviceavailability> { ppmsServiceAvailability };
                    var serviceAvailabilities = await ServiceAvailabilityMap.MapServiceAvailabilities(ppmsServericeAvailabilitiesList, queryType, context);
                    return Request.CreateResponse(serviceAvailabilities);
                }
            }
            var message = string.Format("Service Availabilities with Name: {0} not found", Name);
            HttpError err = new HttpError(message);
            return Request.CreateErrorResponse(HttpStatusCode.OK, err);
        }

        [ODataRoute("ServiceAvailabilities")]
        public async Task<HttpResponseMessage> Get()
        {
            //This Scenario returns the first 50 Service Availabilities in the system. . 
            using (var context = new PpmsContext(await PpmsContextHelper.GetProxy()))
            {
                var ppmsServericeAvailabilities = context.ppms_serviceavailabilitySet.Where(i => i.ppms_name != null).Take(50);
                var ppmsServericeAvailabilitiesList = ppmsServericeAvailabilities.ToList();
                if (ppmsServericeAvailabilitiesList.Any())
                {
                    //Map Service Availabilities
                    var serviceAvailabilities = await ServiceAvailabilityMap.MapServiceAvailabilities(ppmsServericeAvailabilitiesList, "None", context);
                    return Request.CreateResponse(serviceAvailabilities);
                }
                var message = "Service Availabilities Not Found";
                HttpError err = new HttpError(message);
                return Request.CreateErrorResponse(HttpStatusCode.OK, err);
            }
        }       
    }
}